# Extension Icons

You need to create three PNG icon files for the browser extension:

- `icon16.png` - 16×16 pixels (toolbar icon)
- `icon48.png` - 48×48 pixels (extension management page)
- `icon128.png` - 128×128 pixels (Chrome Web Store listing)

## Quick Icon Creation

You can create simple icons using any of these methods:

### Option 1: Online Tool
1. Visit https://www.favicon-generator.org/
2. Upload a logo or create a simple icon
3. Download all sizes

### Option 2: Figma/Design Tool
1. Create a 128×128 artboard
2. Add "P" or Pingbird logo with blue background (#3b82f6)
3. Export as PNG at 128×128, 48×48, and 16×16

### Option 3: ImageMagick (if installed)
```bash
# Create simple "P" icon
convert -size 128x128 xc:none -fill "#3b82f6" \
  -draw "roundrectangle 10,10 118,118 15,15" \
  -fill white -font Arial-Bold -pointsize 80 \
  -gravity center -annotate +0+0 "P" icon128.png

convert icon128.png -resize 48x48 icon48.png
convert icon128.png -resize 16x16 icon16.png
```

## Temporary Placeholders

For now, you can use simple colored squares as placeholders. The extension will work with any valid PNG images.
